function espectro(t,x)
% Funcion que a partir de una seal temporal representa su espectro en
% amplitud
%
% Parametros:
%
% t-> vector de tiempos (con espaciado uniforme)
% x-> valores de la seal en cada instante de tiempo
%
% los tamaos de los vectores t y x deben coincidir

Tmuestreo=t(2)-t(1);

X=fft(x);
X=fftshift(X);
npuntos=length(x);
w=-1/(Tmuestreo*2):1/(Tmuestreo*(npuntos-1)):1/(Tmuestreo*2);
plot(w,abs(X)*Tmuestreo);
xlabel('Hz');
